require 'net/https'
require 'uri'

class PostRequest
  def initialize(url, form_data, headers = {})
    @url = url
    @form_data = form_data
    @headers = headers
  end

  def post(multipart: false)
    uri = URI.parse(@url)
    http = Net::HTTP.new(uri.host, uri.port)
    http.use_ssl = true
    if ENV['disable_ssl_verify'] == '1'
      http.verify_mode = OpenSSL::SSL::VERIFY_NONE
    else
      http.verify_mode = OpenSSL::SSL::VERIFY_PEER
    end
    request = Net::HTTP::Post.new(uri.request_uri)

    if multipart
      request["Content-Type"] = "multipart/form-data"
      request.set_form(@form_data.is_a?(Hash) ? @form_data.to_a : @form_data, "multipart/form-data")
    else
      request["Content-Type"] = "application/x-www-form-urlencoded"
      request.set_form_data(@form_data)
    end

    @headers.each do |header_key, header_value|
      request.add_field(header_key, header_value)
    end

    response = http.request(request)
    response.body
  end
end
